<h1>Upravit produkt</h1>

<form method="post">

    <div class="mb-3">
        <label class="form-label">Název</label>
        <input type="text" name="name" class="form-control"
               value="<?= htmlspecialchars($product->name ?? '') ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Kategorie</label>
        <input type="text" name="category" class="form-control"
               value="<?= htmlspecialchars($product->category ?? '') ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Cena</label>
        <input type="number" step="0.01" name="price" class="form-control"
               value="<?= htmlspecialchars($product->price ?? '') ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Skladem</label>
        <input type="number" name="stock" class="form-control"
               value="<?= htmlspecialchars($product->stock ?? '') ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Dodavatel</label>
        <select name="supplier_id" class="form-control">
            <option value="">-- žádný --</option>
            <?php foreach($suppliers as $s): ?>
                <option value="<?= $s->id ?>"
                    <?= isset($product->supplier_id) && $product->supplier_id == $s->id ? 'selected' : '' ?>>
                    <?= htmlspecialchars($s->name) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <button type="submit" class="btn btn-success">Uložit</button>
    <a href="?controller=product" class="btn btn-secondary">Zpět</a>

</form>
