<?php
// app/Core/Model.php
namespace App\Core;

/**
 * Základní model.
 *
 * - Slouží jako rodičovská třída pro entity (Product, Supplier)
 * - Obsahuje společné metody pro práci s daty
 */
class Model
{
    /**
     * Hromadné naplnění vlastností objektu z pole.
     */
    public function fill(array $data): void
    {
        foreach ($data as $key => $value) {
            // pokud existuje vlastnost se stejným názvem, nastavíme
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * Vrátí objekt jako asociativní pole.
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}