<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\CustomerRepository;

class CustomerController extends Controller
{
    private CustomerRepository $repo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new CustomerRepository($db);
    }

    public function index()
    {
        $items = $this->repo->findAll();
        $this->view->render('customers/index', ['customers' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=customer&action=index');
        }
        $this->view->render('customers/form');
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $customer = $this->repo->find($id);
        if (!$customer) exit('Zákazník nenalezen');

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=customer&action=index');
        }

        $this->view->render('customers/form', ['customer' => $customer]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=customer&action=index');
    }

    private function validate(array $input): array
    {
        return [
            'first_name' => trim($input['first_name'] ?? ''),
            'last_name'  => trim($input['last_name'] ?? ''),
            'email'      => trim($input['email'] ?? ''),
            'phone'      => trim($input['phone'] ?? ''),
            'address'    => trim($input['address'] ?? '')
        ];
    }
}