document.addEventListener('DOMContentLoaded', function () {
    console.log('script.js načten');

    const modal = document.getElementById('imageModal');
    const modalImage = document.getElementById('modalImage');
    const thumbnails = document.querySelectorAll('.gallery-thumb');
    const prevBtn = document.getElementById('prevImage');
    const nextBtn = document.getElementById('nextImage');

    if (!modal || !modalImage || thumbnails.length === 0) {
        console.error('Chybí prvky pro modal nebo miniatury.');
        return;
    }

    let imageSources = Array.from(thumbnails).map(img => img.src);
    let currentIndex = 0;
    let bootstrapModal = new bootstrap.Modal(modal);

    thumbnails.forEach((thumb, index) => {
        thumb.addEventListener('click', function () {
            currentIndex = index;
            modalImage.src = imageSources[currentIndex];
            bootstrapModal.show();
        });
    });

    prevBtn.addEventListener('click', function () {
        currentIndex = (currentIndex - 1 + imageSources.length) % imageSources.length;
        modalImage.src = imageSources[currentIndex];
    });

    nextBtn.addEventListener('click', function () {
        currentIndex = (currentIndex + 1) % imageSources.length;
        modalImage.src = imageSources[currentIndex];
    });
});
