<?php
$mysqli = new mysqli("localhost", "user", "heslo", "databaze");
if ($mysqli->connect_error) {
    die("Chyba připojení: " . $mysqli->connect_error);
}

$radit_podle = "id";
$smer = "ASC";

if (isset($_GET['sort'])) {
    if ($_GET['sort'] === "jmeno") {
        $radit_podle = "jmeno";
    }
}

if (isset($_GET['order']) && strtoupper($_GET['order']) === "DESC") {
    $smer = "DESC";
}

$sql = "SELECT * FROM zakaznici ORDER BY $radit_podle $smer";
$result = $mysqli->query($sql);

if (!$result) {
    die("Chyba dotazu: " . $mysqli->error);
}

$novy_smer = ($smer === "ASC") ? "DESC" : "ASC";
?>
<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <title>Zákazníci</title>
</head>
<body>
    <h1>Seznam zákazníků</h1>
    <p>
        <a href="?sort=jmeno&order=ASC">Řadit podle jména A–Z</a> |
        <a href="?sort=jmeno&order=DESC">Řadit podle jména Z–A</a> |
        <a href="?">Výchozí řazení (podle ID)</a>
    </p>
    <table border="1" cellpadding="5">
        <tr>
            <th>ID</th>
            <th>Jméno</th>
            <th>Město</th>
            <th>Rok narození</th>
            <th>Počet nákupů</th>
            <th>Celková útrata</th>
        </tr>
        <?php while($radek = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($radek['id']) ?></td>
            <td><?= htmlspecialchars($radek['jmeno']) ?></td>
            <td><?= htmlspecialchars($radek['mesto']) ?></td>
            <td><?= htmlspecialchars($radek['rok_narozeni']) ?></td>
            <td><?= htmlspecialchars($radek['pocet_nakupu']) ?></td>
            <td><?= htmlspecialchars($radek['celkova_utrata']) ?> Kč</td>
        </tr>
        <?php endwhile; ?>
    </table>
</body>
</html>
