<?php 
    session_start();

    // zpracování přihlášení
    if($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["btn-login"])){
        $login = htmlspecialchars($_POST["login"]);
        $plain_pass = $_POST["password"];
        $password = password_hash($plain_pass, PASSWORD_BCRYPT);
        
        $result = check_user($login,$plain_pass);
        if($result == true){
            $_SESSION["user"] = $login;
            header("Location: tajna-sekce.php" );
        } else {
            $errorLogin = "Nesprávné jméno nebo heslo.";
        }
        
    }

    // zpracování registrace
    if($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["btn-register"])){
        $login = htmlspecialchars($_POST["login"]);
        $plain_pass = $_POST["password"];
        $password = password_hash($plain_pass, PASSWORD_BCRYPT);
        
        $result = check_user($login);
        if($result == true){
            $errorRegister = "Uživatel s tímto jménem již existuje.";
        } else {
            $data = "$login***$password\n";
            file_put_contents("data/users.csv",$data,FILE_APPEND);
            header("Location:" . $_SERVER["PHP_SELF"]);
        }
    }

    function check_user($login, $password=false){
        $result = false;
        if(file_exists("data/users.csv")){
            $file = fopen("data/users.csv","r");
            while(!feof($file)){
                $row = fgets($file);
                $data = explode("***", $row);
                if($login == trim($data[0]) && 
                (password_verify($password,trim($data[1])) || !$password)){
                    $result = true;
                    break;
                }
            }
            fclose($file);
        }
        return $result;
    }

?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">

        <div class="row">
            <!-- registrace-->
            <div class="col-md-6">
                <h2>Registrace</h2>
                <form method="post" class="bg-light py-3 px-4">
                    <div class="mb-3">
                        <label class="form-label">Přihlašovací jméno</label>
                        <input type="text" name="login" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Heslo</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <button type="submit" name="btn-register" class="btn btn-success">Registrovat</button>
                </form>
                <p class="text-danger"><?=$errorRegister;?></p>
            </div>
            <!-- konec registrace-->

            <!-- přihlašení -->
            <div class="col-md-6">
                <h2>Přihlášení</h2>
                <form method="post" class="bg-light py-3 px-4">
                    <div class="mb-3">
                        <label class="form-label">Přihlašovací jméno</label>
                        <input type="text" name="login" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Heslo</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <button type="submit" name="btn-login" class="btn btn-primary">Přihlásit</button>
                </form>
                <p class="text-danger"><?=$errorLogin;?></p>
            </div>
            <!-- konec přihlášení-->

        </div>

    </div>
    
</body>
</html>