<?php
// public/index.php
// front controller / router

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// přepnout PHP chyby na výjimky (snazší trace)
set_error_handler(function ($severity, $message, $file, $line) {
    throw new ErrorException($message, 0, $severity, $file, $line);
});

set_exception_handler(function (Throwable $e) {
    http_response_code(500);
    echo "<pre>Uncaught " . get_class($e) . ": " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n\n";
    echo $e->getTraceAsString();
    echo "</pre>";
    error_log($e);
});

register_shutdown_function(function () {
    $err = error_get_last();
    if ($err) {
        http_response_code(500);
        echo "<pre>Fatal error: {$err['message']} in {$err['file']} on line {$err['line']}</pre>";
    }
});

require_once __DIR__ . '/../app/bootstrap.php'; // autoload + helper config()

use App\Core\Database;
use App\Controllers\LekarController;
use App\Controllers\PacientController;
use App\Controllers\NavstevaController;

// načíst konfiguraci DB a vytvořit instanci Database
$dbConfig = config()['db'];
$db = new Database($dbConfig);

// jednoduchý router podle GET parametrů
$controller = $_GET['controller'] ?? 'product';
$action = $_GET['action'] ?? 'index';

// vytvoření controllera (mapování)
switch (strtolower($controller)) {
    case 'lekar':
        $c = new LekarController($db);
        break;
    case 'pacient':
        $c = new PacientController($db);
        break;
    case 'navsteva':
        $c = new NavstevaController($db);
        break;
    default:
        $c = new PacientController($db);
}

// ověření existující metody
if (!method_exists($c, $action)) {
    http_response_code(404);
    echo 'Akce nenalezena';
    exit;
}

// zavolat akci
$c->{$action}();