<?php
// app/Models/SupplierRepository.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\PacientEntity;

class PacientRepository extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'pacienti', PacientEntity::class);
    }

    /**
     * Vytvoří nového pacienta z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO pacienti (jmeno, prijmeni, email, telefon, datum_narozeni, lekar_id) VALUES (:jmeno, :prijmeni, :email, :telefon, :datum_narozeni, :lekar_id)");
        $stmt->execute([
            'jmeno' => $data['jmeno'],
            'prijmeni' => $data['prijmeni'],
            'email' => $data['email'] ?? null,
            'telefon' => $data['telefon'] ?? null,
            'datum_narozeni' => $data['datum_narozeni'] ?? null,
            'lekar_id' => $data['lekar_id'] ?? null
        ]);
        return (int)$this->pdo->lastInsertId();
    }

    /**
     * Aktualizuje pacienta podle id.
     */
    public function update(int $id, array $data): bool
    {
        $stmt = $this->pdo->prepare("UPDATE pacienti SET jmeno=:jmeno, prijmeni=:prijmeni, email=:email, telefon=:telefon, datum_narozeni=:datum_narozeni, lekar_id=:lekar_id WHERE id=:id");
        return $stmt->execute([
            'jmeno'  => $data['jmeno'],
            'prijmeni' => $data['prijmeni'],
            'email' => $data['email'] ?? null,
            'telefon' => $data['telefon'] ?? null,
            'datum_narozeni' => $data['datum_narozeni'] ?? null,
            'lekar_id' => $data['lekar_id'] ?? null,
            'id'    => $id
        ]);
    }
}