<?php
// app/Models/SupplierRepository.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\NavstevaEntity;

class NavstevaRepository extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'navsteva', NavstevaEntity::class);
    }

    /**
     * Vytvoří novou návštěvu z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO navsteva (lekar_id, pacient_id, duvod_navstevy) VALUES (:lekar_id, :pacient_id, :duvod_navstevy)");
        $stmt->execute([
            'lekar_id' => $data['lekar_id'],
            'pacient_id' => $data['pacient_id'],
            'duvod_navstevy' => $data['duvod_navstevy']
        ]);
        return (int)$this->pdo->lastInsertId();
    }
       

    /**
     * Aktualizuje návštěvu podle id.
     */
    public function update(int $id, array $data): bool
    {
        $stmt = $this->pdo->prepare("UPDATE navsteva SET lekar_id=:lekar_id, pacient_id=:pacient_id, duvod_navstevy=:duvod_navstevy WHERE id=:id");
        return $stmt->execute([
            'lekar_id' => $data['lekar_id'],
            'pacient_id' => $data['pacient_id'],
            'duvod_navstevy' => $data['duvod_navstevy'],
            'id'    => $id
        ]);
    }
}