<?php
// app/Models/SupplierRepository.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\LekarEntity;

class LekarRepository extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'lekari', LekarEntity::class);
    }

    /**
     * Vytvoří nového lékaře z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO lekari (jmeno_prijmeni) VALUES (:jmeno_prijmeni)");
        $stmt->execute([
            'jmeno_prijmeni' => $data['jmeno_prijmeni']
        ]);
        return (int)$this->pdo->lastInsertId();
    }
   

    /**
     * Aktualizuje lékaře podle id.
     */
    public function update(int $id, array $data): bool
    {
        $stmt = $this->pdo->prepare("UPDATE lekari SET jmeno_prijmeni=:jmeno_prijmeni WHERE id=:id");
        return $stmt->execute([
            'jmeno_prijmeni' => $data['jmeno_prijmeni'],
            'id'    => $id
        ]);
    }
}