<?php
// app/Controllers/SupplierController.php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\PacientRepository;
use App\Models\LekarRepository;

class PacientController extends Controller
{
    private PacientRepository $repo;
    private LekarRepository $lekRepo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new PacientRepository($db);
        $this->lekRepo = new LekarRepository($db);
    }

    public function index()
    {
        // vrací PacientEntity[]
        $items = $this->repo->findAll();
        $this->view->render('pacienti/index', ['pacienti' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=pacient&action=index');
        }
        $lekari = $this->lekRepo->findAll();
        $this->view->render('pacienti/form', ['lekari' => $lekari]);
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $pacient = $this->repo->find($id);
        if (!$pacient) {
            http_response_code(404);
            echo 'Pacient nenalezen';
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=pacient&action=index');
        }

        $this->view->render('pacienti/edit', ['pacient' => $pacient]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=pacient&action=index');
    }

    public function show()
    {
        $id = (int)($_GET['id'] ?? 0);
        $pacient = $this->repo->find($id);
        if (!$pacient) {
            http_response_code(404);
            echo 'Pacient nenalezen';
            exit;
        }
        $this->view->render('pacienti/show', ['pacient' => $pacient]);
    }

    /**
     * Základní validace vstupu z formuláře.
     * Vrací pole připravené pro repository (create/update).
     */
    private function validate(array $input): array
    {
        return [
            'jmeno' => trim($input['jmeno'] ?? ''),
            'prijmeni' => trim($input['prijmeni'] ?? ''),
            'datum_narozeni' => trim($input['datum_narozeni']) ?: null,
            'telefon' => trim($input['telefon']) ?: null,
            'lekar_id' => !empty($input['lekar_id']) ? (int)$input['lekar_id'] : null
        ];
    }
}