<?php
// app/Controllers/SupplierController.php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\NavstevaRepository;

class NavstevaController extends Controller
{
    private NavstevaRepository $repo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new NavstevaRepository($db);
    }

    public function index()
    {
        // vrací NavstevaEntity[]
        $items = $this->repo->findAll();
        $this->view->render('navstevy/index', ['navstevy' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=navsteva&action=index');
        }
        $this->view->render('navstevy/form');
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $navsteva = $this->repo->find($id);
        if (!$navsteva) {
            http_response_code(404);
            echo 'Návštěva nenalezena';
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=navsteva&action=index');
        }

        $this->view->render('navstevy/edit', ['navsteva' => $navsteva]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=navsteva&action=index');
    }

    public function show()
    {
        $id = (int)($_GET['id'] ?? 0);
        $navsteva = $this->repo->find($id);
        if (!$navsteva) {
            http_response_code(404);
            echo 'Návštěva nenalezena';
            exit;
        }
        $this->view->render('navstevy/show', ['navsteva' => $navsteva]);
    }

    /**
     * Základní validace vstupu z formuláře.
     * Vrací pole připravené pro repository (create/update).
     */
    private function validate(array $input): array
    {
        return [
            'pacient_id' => !empty($input['pacient_id']) ? (int)$input['pacient_id'] : null,
            'lekar_id' => !empty($input['lekar_id']) ? (int)$input['lekar_id'] : null,
            'duvod_navstevy' => trim($input['duvod_navstevy'] ?? ''),
            'datum_navstevy' => trim($input['datum_navstevy']) ?: null,
            'cas_navstevy' => trim($input['cas_navstevy']) ?: null
        ];
    }
}