<?php
// app/Controllers/SupplierController.php
namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;
use App\Models\LekarRepository;

class LekarController extends Controller
{
    private LekarRepository $repo;

    public function __construct(Database $db)
    {
        parent::__construct();
        $this->repo = new LekarRepository($db);
    }

    public function index()
    {
        // vrací LekarEntity[]
        $items = $this->repo->findAll();
        $this->view->render('lekar/index', ['lekari' => $items]);
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->create($data);
            $this->redirect('?controller=lekar&action=index');
        }
        $this->view->render('lekar/form');
    }

    public function edit()
    {
        $id = (int)($_GET['id'] ?? 0);
        $lekar = $this->repo->find($id);
        if (!$lekar) {
            http_response_code(404);
            echo 'Lékař nenalezen';
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $this->validate($_POST);
            $this->repo->update($id, $data);
            $this->redirect('?controller=lekar&action=index');
        }

        $this->view->render('lekar/edit', ['lekar' => $lekar]);
    }

    public function delete()
    {
        $id = (int)($_GET['id'] ?? 0);
        $this->repo->delete($id);
        $this->redirect('?controller=lekar&action=index');
    }

    public function show()
    {
        $id = (int)($_GET['id'] ?? 0);
        $lekar = $this->repo->find($id);
        if (!$lekar) {
            http_response_code(404);
            echo 'Lékař nenalezen';
            exit;
        }
        $this->view->render('lekar/show', ['lekar' => $lekar]);
    }

    /**
     * Základní validace vstupu z formuláře.
     * Vrací pole připravené pro repository (create/update).
     */
    private function validate(array $input): array
    {
        return [
            'jmeno_prijmeni' => trim($input['jmeno_prijmeni'] ?? '')
        ];
    }
}