<?php

namespace App\Model;

use mysqli;

class Task
{
    private mysqli $db;

    public function __construct($stmt)
    {
        $this->db = $stmt;
    }

    public function getAllTasks(): array
    {
        $stmt = $this->db->prepare("SELECT * FROM tasks ORDER BY due_date");
        $stmt->execute();
        $result = $stmt->get_result();

        return $result->fetch_all(MYSQLI_ASSOC);
    }

    public function getTask(int $task_id): array
    {
        $stmt = $this->db->prepare("SELECT * FROM tasks WHERE id = ?");
        $stmt->bind_param("i", $task_id);
        $stmt->execute();
        $result = $stmt->get_result();

        return $result->fetch_assoc();
    }

    public function addTask(Task $task): void
    {
        $stmt = $this->db->prepare("INSERT INTO tasks (title,description,due_date,is_completed) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $task['title'], $task['description'], $task['due_date'], $task['is_completed']);
        $stmt->execute();
    }

    public function updateTask(Task $task, int $task_id): void
    {
        $stmt = $this->db->prepare("UPDATE tasks SET title = ?, description = ?,due_date = ?, is_completed = ? WHERE id = ?");
        $stmt->bind_param("ssssi", $task['title'], $task['description'], $task['due_date'], $task['is_completed'], $task_id);
        $stmt->execute();
    }

    public function deleteTask(int $task_id): void
    {
        $stmt = $this->db->prepare("DElETE FROM tasks WHERE id = ?");
        $stmt->bind_param("i",$task_id);
        $stmt->execute();
    }
}