<?php
    $server = "websql.in.spsostrov.cz";
    $data = parse_ini_file("../../spso.mysql.ini");
    $username = $data["username"];
    $password = $data["password"];
    $database = $data["database"];

    $pdo = new PDO("mysql:host=$server;dbname=$database;charset=utf8mb4", $username, $password);

    $dotaz = []; //dotazy budou v poli

    for($i=1; $i<=5;$i++){
        if(isset($_GET["filtr"])){
            switch($_GET["filtr"]){
                case "nejlevnejsi": 
                    $dotaz[$i] = "SELECT*FROM jidlo WHERE id_kategorie = $i ORDER BY cena";
                break;

                case "nejdrazsi":
                    $dotaz[$i] = "SELECT*FROM jidlo WHERE id_kategorie = $i ORDER BY cena DESC";
                break;

                case "abeceda":
                    $dotaz[$i] = "SELECT*FROM jidlo WHERE id_kategorie = $i ORDER BY nazev";
                break;

                default:
                    $dotaz[$i] = "SELECT*FROM jidlo WHERE id_kategorie = $i ORDER BY nazev";
                break;
            }
        }
        else{
            $dotaz[$i] = "SELECT*FROM jidlo WHERE id_kategorie = $i ORDER BY nazev";
        }

        $result[$i] = $pdo->query($dotaz[$i])->fetchAll();       
    }
    $pdo = null;

    include("02-sql-helper.php");
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css">

    <title>Jídelní lístek</title>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <h1>Jídelní lístek</h1>
                <?php
                    echo "<h2>Předkrmy</h2>";
                    vypis($result[5]);

                    echo "<h2>Polévky</h2>";
                    vypis($result[1]);

                    echo "<h2>Hlavní jídla</h2>";
                    vypis($result[2]);

                    echo "<h2>Dezerty</h2>";
                    vypis($result[4]);

                    echo "<h2>Nápoje</h2>";
                    vypis($result[3]);
                ?>
            </div>

            <div class="col-md-3">
                <a href="?filtr=nejlevnejsi" class="btn btn-sm btn-primary m-2 d-block">Od nejlevnějšího</a>
                <a href="?filtr=nejdrazsi" class="btn btn-sm btn-primary m-2 d-block">Od nejdražšího</a>
                <a href="?filtr=abeceda" class="btn btn-sm btn-primary m-2 d-block">Podle abecedy</a>
            </div>
        </div>
    </div>
    <script>
        Fancybox.bind('[data-fancybox="gallery"]', {
            // Your custom options for a specific gallery
        });
    </script>
</body>
</html>