<?php 
    if($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["add-btn"])){
        $nickname = htmlspecialchars($_POST["nickname"]);
        $date = date("d.m.Y H:i");
        $content = htmlspecialchars($_POST["content"]);

        $res = "$nickname***$date***$content\n";
        file_put_contents("data/diskuse.csv", $res, FILE_APPEND);
        header("Location: " . $_SERVER["PHP_SELF"]);
    }

    function getContent(){
        $res = "";
        if(file_exists("data/diskuse.csv")){
            $file = fopen("data/diskuse.csv","r");
            while(!feof($file)){
                $row = fgets($file);
                $data = explode("***", $row);
                if(count($data) != 3)
                    continue;
                $new = "<strong>{$data[0]}</strong>, {$data[1]}:<br>";
                $new .= "<p>{$data[2]}</p>";
                $res = $new . $res;
            }
            fclose($file);
        }
        echo $res;
    }

?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diskuse</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .blok-diskuse {
           /* min-height: 200vh; */
        }
        .blok-form {
            position: sticky;
            top: 40px;
        }
        @media (max-width: 767px){
            .wrapper-diskuse {
                order: 2;
            }
        }
    </style>
</head>
<body>
    <div class="container-lg">
        <div class="row">
            <!--diskusní příspěvky-->
            <div class="col-lg-8 col-md-7 wrapper-diskuse">
                <h1>Diskuse</h1>
                <div class="blok-diskuse">
                    <?php getContent(); ?>
                </div>
            </div>

            <!--formulář-->
            <div class="col-lg-4 col-md-5">
                <form method="post" class="blok-form bg-light p-3 rounded">
                    <div class="form-floating mb-3">
                        <input type="text" name="nickname" placeholder="Vaše přezdívka" class="form-control" required>
                        <label>Přezdívka</label>
                    </div>

                    <div class="form-floating mb-3">
                        <textarea name="content" placeholder="Váš příspěvek" class="form-control" required></textarea>
                        <label>Příspěvek</label>
                    </div>

                    <button type="submit" name="add-btn" class="btn btn-primary">Vložit do diskuse</button>
                </form>
            </div>
        </div>

    </div>
</body>
</html>