<?php
// public/index.php
// front controller / router
 error_reporting(E_ALL);
 ini_set("display_errors", 1);
 
require_once __DIR__ . '/../app/bootstrap.php'; // autoload + helper config()

use App\Core\Database;

// načíst konfiguraci DB a vytvořit instanci Database
$dbConfig = config()['db'];
$db = new Database($dbConfig);

// jednoduchý router podle GET parametrů
$controller = $_GET['controller'] ?? 'product';
$action = $_GET['action'] ?? 'index';

// vytvoření controllera (mapování)
switch (strtolower($controller)) {
    case 'supplier':
        $c = new App\Controllers\SupplierController($db);
        break;
    case 'customer':
        $c = new App\Controllers\CustomerController($db);
        break;
    default:
        $c = new App\Controllers\ProductController($db);
}

// ověření existující metody
if (!method_exists($c, $action)) {
    http_response_code(404);
    echo 'Akce nenalezena';
    exit;
}

// zavolat akci
$c->{$action}();