
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
    <h1>Produkty</h1>

    <p>
        <a class="btn btn-success" 
        href="?controller=product&action=create">
            + Přidat produkt
        </a>
    </p>

    <table class="table">
    <thead>
        <tr><th>ID</th><th>Název</th><th>Kategorie</th><th>Cena</th><th>Skladem</th><th>Dodavatel</th><th>Akce</th></tr>
    </thead>
    <tbody>
    <?php foreach($products as $p): ?>
        <tr>
        <td><?=htmlspecialchars($p->id)?></td>
        <td><?=htmlspecialchars($p->name)?></td>
        <td><?=htmlspecialchars($p->category)?></td>
        <td><?=number_format((float)$p->price, 2, ',', ' ')?></td>
        <td><?=htmlspecialchars($p->stock)?></td>
        <td><?=htmlspecialchars($p->supplier_name ?? '-')?></td>
        <td>
            <a class="btn btn-primary" href="?controller=product&action=show&id=<?= $p->id ?>">
                <i class="bi bi-eye-fill"></i>
            </a>
            <a class="btn btn-success" href="?controller=product&action=edit&id=<?= $p->id ?>">
                <i class="bi bi-gear-fill"></i>
            </a>
            <a class="btn btn-danger" href="?controller=product&action=delete&id=<?= $p->id ?>" onclick="return confirm('Opravdu smazat?')">
                <i class="bi bi-trash-fill"></i>
            </a>
        </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
    </table>
