<?php
// app/Models/Customer.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\CustomerEntity;

class Customer extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'customers', CustomerEntity::class);
    }

    /**
     * Vytvoří nového dodavatele z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     *
     * @param array $data
     * @return int
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO customers (name, email, phone, address) VALUES (:name, :email, :phone, :address)");
        $stmt->execute([
            'name'  => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null
            'address' => $data['address'] ?? null
        ]);
        return (int)$this->pdo->lastInsertId();
    }

    /**
     * Aktualizuje dodavatele podle id.
     *
     * @param int $id
     * @param array $data
     * @return bool
     */
    public function update(int $id, array $data): bool
    {
        $stmt = $this->pdo->prepare("UPDATE customers SET name=:name, email=:email, phone=:phone, address=:address WHERE id=:id");
        return $stmt->execute([
            'name'  => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null,
            'address' => $data['address'] ?? null
            'id'    => $id
        ]);
    }
}